﻿#pragma once
#include "component.h"

namespace RTCam {

class Mesh;
class Material;

class MeshRenderer : public Component
{
public:
	MeshRenderer(const shared_ptr<Entity>& entity);
	~MeshRenderer(void);

	void UpdateCBuffer();

	void SetMesh(const shared_ptr<Mesh>& mesh);
	void SetMaterial(const shared_ptr<Material>& material);

	shared_ptr<Mesh> GetMesh() { return m_mesh; }
	shared_ptr<Material> GetMaterial() { return m_material; }

	bool m_meshWarningPrinted;

private:
	// TODO: Support multiple materials per mesh with vertex groups
	
	//weak_ptr<Mesh> m_mesh;
	//weak_ptr<Material> m_material;

	// HACK: Making these into strong references for now until the resource system is complete
	shared_ptr<Mesh> m_mesh;
	shared_ptr<Material> m_material;
	// END HACK

};

} // end namespace